/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.list;

import cz.insophy.inplan.util.BiPeekingIterator;
import cz.insophy.inplan.util.list.SortedList;
import cz.insophy.inplan.util.list.ThreadedAvlTree;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TreeList<T>
implements SortedList<T> {
    private final ThreadedAvlTree<T> tree;

    public TreeList(Comparator<T> comparator) {
        this.tree = new ThreadedAvlTree<T>(comparator);
    }

    @Override
    public boolean add(T e) {
        this.tree.insert(e);
        return true;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " not within [0; " + this.size() + ").");
        }
        ListIterator<T> iterator = this.listIterator(index);
        return iterator.next();
    }

    @Override
    public int indexOf(Object o) {
        Object p = o;
        ListIterator<T> iterator = this.listIterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (iterator.next().equals(p)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new TreeIterator<T>(this.tree, this.tree.getMinimumNode(), null);
    }

    @Override
    public int lastIndexOf(Object o) {
        TreeIterator<T> iter = new TreeIterator<T>(this.tree, null, this.tree.getMaximumNode());
        int pos = this.size();
        while (iter.hasPrevious()) {
            --pos;
            if (!iter.previous().equals(o)) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        int size = this.tree.getSize();
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        if (index < size / 2) {
            ListIter<T> iterator = new ListIter<T>(this.tree, this.tree.getMinimumNode(), null);
            for (int i = 0; i < index; ++i) {
                iterator.next();
            }
            return iterator;
        }
        ListIter<T> iterator = new ListIter<T>(this.tree, null, this.tree.getMaximumNode());
        for (int i = 0; i < size - index; ++i) {
            iterator.previous();
        }
        return iterator;
    }

    @Override
    public T remove(int index) {
        T value = this.get(index);
        this.tree.removeEquals(value);
        return value;
    }

    @Override
    public boolean remove(Object o) {
        Object p = o;
        if (this.contains(p)) {
            this.tree.removeEquals(p);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            Object p = o;
            if (!this.tree.containsEquals(p)) continue;
            this.tree.removeEquals(p);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.tree.getSize();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T1[])new Object[0]);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        if (a.length < this.size()) {
            a = new Object[this.size()];
        }
        int i = 0;
        for (T e : this) {
            a[i++] = e;
        }
        if (i != a.length) {
            a[i] = null;
        }
        return a;
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public boolean contains(Object o) {
        Object p = o;
        return this.tree.containsEquals(p);
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public T nextOf(T o) {
        ThreadedAvlTree.Node<T> node = this.tree.getNextOf(o);
        return node != null ? (T)node.value : null;
    }

    @Override
    public T previousOf(T o) {
        ThreadedAvlTree.Node<T> node = this.tree.getPreviousOf(o);
        return node != null ? (T)node.value : null;
    }

    @Override
    public BiPeekingIterator<T> iterator(T from) {
        ThreadedAvlTree.Node<T> next = this.tree.getNextOf(from);
        ThreadedAvlTree.Node<T> prev = next != null ? (next.leftThread ? next.left : this.tree.getMaximumNode(next.left)) : this.tree.getMaximumNode();
        return new TreeIterator<T>(this.tree, next, prev);
    }

    public static <T> TreeList<T> create(Comparator<T> comparator) {
        return new TreeList<T>(comparator);
    }

    private static class TreeIterator<T>
    implements BiPeekingIterator<T> {
        private final ThreadedAvlTree<T> tree;
        private ThreadedAvlTree.Node<T> prev;
        private ThreadedAvlTree.Node<T> next;

        public TreeIterator(ThreadedAvlTree<T> tree, ThreadedAvlTree.Node<T> next, ThreadedAvlTree.Node<T> prev) {
            this.tree = tree;
            this.next = next;
            this.prev = prev;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object value = this.next.value;
            this.prev = this.next;
            this.next = this.next.rightThread ? this.next.right : this.tree.getMinimumNode(this.next.right);
            return value;
        }

        @Override
        public T previous() {
            if (this.prev == null) {
                throw new NoSuchElementException();
            }
            Object value = this.prev.value;
            this.next = this.prev;
            this.prev = this.prev.leftThread ? this.prev.left : this.tree.getMaximumNode(this.prev.left);
            return value;
        }

        @Override
        public T peekPrevious() {
            if (this.prev == null) {
                throw new NoSuchElementException();
            }
            return this.prev.value;
        }

        @Override
        public T peekNext() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ListIter<T>
    extends TreeIterator<T>
    implements ListIterator<T> {
        public ListIter(ThreadedAvlTree<T> tree, ThreadedAvlTree.Node<T> next, ThreadedAvlTree.Node<T> prev) {
            super(tree, next, prev);
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

